package org.compiere.model;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;

import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutQuestionnaire extends CalloutEngine {
	
	
	public String price (Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue)
	{
		
		BigDecimal new_price = (BigDecimal )value;
		BigDecimal old_price = (BigDecimal )oldValue;
		if(old_price == null)
			old_price = Env.ZERO;
		
		if(new_price.compareTo(old_price) < 0)
			return "金額が低くなっていますよ!!";
		
		return "";
	}
	
	
	public String price2 (Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value)
	{
		String columnName = mField.getColumnName();
		
		BigDecimal new_price = (BigDecimal )value;
		BigDecimal old_price = Env.ZERO;
		BigDecimal old_price2 = Env.ZERO;

		
		String sql = "SELECT price, price2 " // 1..2
				+ "FROM Q_Questionnaire "
				+ "WHERE Q_Questionnaire_ID=?";		//	1
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			try
			{
				pstmt = DB.prepareStatement(sql, null);
				pstmt.setInt(1, Env.getContextAsInt(ctx, WindowNo, WindowNo, "Q_Questionnaire_ID"));
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					old_price = rs.getBigDecimal(1);
					old_price2 = rs.getBigDecimal(2);
				}
			}
			catch (SQLException e)
			{
				log.log(Level.SEVERE, sql, e);
				return e.getLocalizedMessage();
			}
			finally
			{
				DB.close(rs, pstmt);
				rs = null; pstmt = null;
			}
		
		if(columnName.equals("Price"))
		{
			if(new_price.compareTo(old_price) < 0)
			{
				mTab.fireDataStatusEEvent ("金額が低くなっていますよ!!",old_price.toString(),true);
			}
			
		}else if(columnName.equals("Price2")){
			
			if(new_price.compareTo(old_price2) < 0)
			{
				mTab.fireDataStatusEEvent ("金額が低くなっていますよ!!",old_price2.toString(),false);
				mTab.setValue(mField, old_price2);
			}
			
		}
			
		return "";
	}
	
}
